<?php $pageid = get_the_id(); ?>
<section class="our-products px-1 px-lg-0">
    <div class="container">
        <div class="row">
            <div class="col-md-12 main-title text-md-center">
                <h1><?php echo get_post_meta($pageid, 'our_product_title', true); ?></h1>
                <p><?php echo get_post_meta($pageid, 'our_product_description', true); ?></p>
                <div class="border-highlight"></div>
            </div>

            <?php
            $slider_ids = get_post_meta($pageid, 'our_product_selector', true);
            if (!$slider_ids) {
                $slider_ids = array();
            }
            $slider_args = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => 5,
                'orderby' => 'menu_order',
                'include'   => $slider_ids,
                'order' => 'ASC',
            );
            $sliderlist = get_posts($slider_args);
            $count = count($sliderlist);

            // Set a flag to check if we have shown any products yet
            $products_shown = false;

            // Loop through the products
            foreach ($sliderlist as $n => $product) {

                // Check conditions and display the designs accordingly
                if ($count == 3 || ($count == 5 && $n < 3) || ($count == 4 && $n < 3)) { ?>
                    <!--// Display first design-->

                    <div class="col-12 col-sm-4 p-1 d-none d-md-block">
                        <div class="position-relative">
                            <img src="<?php echo get_the_post_thumbnail_url($product); ?>" alt="" class="img-fluid w-100">
                            <div class="img-over-bg">
                                <div class="img-over-text">
                                    <h3><?php echo get_the_title($product); ?></h3>
                                    <a href="<?php echo get_permalink($product); ?>">Explore More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php $products_shown = true;
                } elseif ($count == 5 && $n >= 3) { ?>
                    <!--// Display second design-->
                    <!--// echo '-->
                    <div class="col-12 col-sm-6 p-1 d-none d-md-block">
                        <div class="position-relative">
                            <img src="<?php echo get_the_post_thumbnail_url($product); ?>" alt="" class="img-fluid w-100">
                            <div class="img-over-bg">
                                <div class="img-over-text">
                                    <h3><?php echo get_the_title($product); ?></h3>
                                    <a href="<?php echo get_permalink($product); ?>">Explore More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php
                    $products_shown = true;
                }
            }

            // If no products were shown, display a message or fallback content
            if (!$products_shown) {
                echo '<style>.our-products.px-1.px-lg-0 { display: none; }</style>';
            }

            wp_reset_postdata();
            ?>


            <!-- 				do not touch -->

            <div class="swiper our-product px-1 px-lg-0 d-block d-md-none">
                <!-- Additional required wrapper -->
                <div class="swiper-wrapper">
                    <!-- Slides -->
                    <?php foreach ($sliderlist as $product) { ?>
                        <div class="swiper-slide">
                            <div class="position-relative">
                                <div class="tab-img-object">
                                    <img src="<?php echo get_the_post_thumbnail_url($product); ?>" alt="Tractors" class="img-fluid w-100">
                                    <div class="img-over-text">
                                        <h3><?php echo get_the_title($product); ?></h3>
                                        <a href="<?php echo get_permalink($product); ?>">Explore More</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>
