<?php
/**
Template Name: main product
 */
get_header(); 
$pageid = get_the_id();?>
<style>
    .img-container {
        border: 1px solid #ccc;
        width: 100%;
        max-width:100%;
        margin: 0 auto;
        padding:0;
        cursor: ew-resize;
    }

    .img360 {
        width: 100%;
        margin: 0;
        padding: 0;
        line-height: 0;
    }
    #preload-imgs {
        display:none;
    }
 </style>
    <div class="position-relative">
        <?php $top_banner = get_post_meta($pageid, 'top_banner', true);?>
        <img src="<?php echo wp_get_attachment_url($top_banner); ?>" alt="banner" class="img-fluid w-100">
        <div class="banner-icons px-md-5 mx-md-4 px-3">
            <div>
                <ul>
                    <li>
                        <img src="<?php echo get_site_url();?>/wp-content/uploads/2023/08/zetor.png" alt="icon" class="img-fluid">
                        <a href="#"><img src="<?php echo get_site_url();?>/wp-content/uploads/2023/08/vst-zetor.png" alt="logo" class="img-fluid"></a>
                    </li>
                    <li>
                        <img src="<?php echo get_site_url();?>/wp-content/uploads/2023/08/earth.png" alt="icon" class="img-fluid">
                        <a href="#"><img src="<?php echo get_site_url();?>/wp-content/uploads/2023/08/earth.png" alt="icon" class="img-fluid">
                            <h5>International</h5>
                        </a>
                    </li>
                </ul>
                <ul>
<!--                     <li class="whatsapp">
                <a href="https://wa.me/9999999999" target="_blank"><img src="<?php echo get_site_url();?>/wp-content/uploads/2023/08/whatsapp_1.png" alt="icon" class="img-fluid"></a>
 </li> -->
                    <li class="become-dealer">
                        <img src="<?php echo get_site_url();?>/wp-content/uploads/2023/08/tracktor.png" alt="icon" class="img-fluid">
                        <a href="<?php echo get_site_url();?>/dealer-locators/">
                            <h5>Dealer Locator</h5> <img src="<?php echo get_site_url();?>/wp-content/uploads/2023/08/tracktor.png" alt="icon" class="img-fluid">
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
     
    <!-- Why VST Series 9 start -->
    <section class="series-9 px-1 px-lg-0">
        <div class="container-fluid px-md-5">
            <div class="row">
<!--                 <div class="col-md-12 main-title text-md-center">
                    <h1><?php //echo get_post_meta($pageid, 'series_section_title', true);?></h1>
                    <p><?php //echo get_post_meta($pageid, 'series_section_description', true);?></p>
                    <div class="border-highlight-listing"></div>
                </div> -->

<!--                 <div class="col-md-12 main-title text-md-center">
                    <h1>Series 9 Products</h1> 
                    <div class="border-highlight"></div>
                </div> -->

<?php
// Define arguments for the custom post type query
$args = array(
    'post_type'      => 'product',
    'post_status'    => 'publish',
    'posts_per_page' => -1,
    'order'          => 'ASC',
);

// Create a new query with the arguments
$custom_query = new WP_Query( $args );

if ( $custom_query->have_posts() ) {
    while ( $custom_query->have_posts() ) {
        $custom_query->the_post();

        $thumbnail_url = get_the_post_thumbnail_url();

        $product_hp = get_post_meta( get_the_ID(), 'product_hp', true );
        $product_cc = get_post_meta( get_the_ID(), 'product_cc', true );
        $main_product_title = get_the_title();
        ?>

        <div class="col-md-4 p-md-3 p-1">
            <div class="bg">
                <div class="mask maskelement">
                    <img src="<?php echo $thumbnail_url; ?>" alt="vst-918" class="img-fluid w-100">
                </div>
                <div class="mb-4">
                    <h3><?php echo $main_product_title; ?></h3>
                    <ul>
                        <li><img src="<?php echo get_site_url();?>/wp-content/uploads/2023/08/horse-power.png" alt="Horse Power">HP : <?php echo $product_hp; ?></li>
                        <li><img src="<?php echo get_site_url();?>/wp-content/uploads/2023/08/engine.png" alt="engine">CC : <?php echo $product_cc; ?></li>
                    </ul>
                </div>
<!--                 <a href="#" data-bs-toggle="modal" data-bs-target="#full-specification">Full Specifications</a> -->
				<a href="#" data-bs-toggle="modal" data-bs-target="#full-specification" data-product-title="<?php echo esc_attr($main_product_title); ?>">Full Specifications</a>

            </div>
        </div>

        <?php
    }

    // Reset post data
    wp_reset_postdata();
} else {
    // No posts found
    echo 'No posts found.';
}
?>
            </div>
        </div>
        <!-- Modal -->
        <div class="modal fade" id="full-specification" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="full-specificationLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="full-specificationLabel">Fill in the form below to get in touch with us.</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row align-items-center">
                            <div class="col-md-5">
                                <img src="<?php echo get_site_url();?>/wp-content/uploads/2023/08/side-bnr.png" alt="banner" class="img-fluid">
                            </div>
                            <div class="col-md-7">
                                
                               <form method="post" action="" id="senddata">
                                    <div class="mb-3"> 
                                        <input type="text" class="form-control" id="userName" name="fname" aria-describedby="textHelp" placeholder="Name" required> 
                                    </div>
                                    <div class="mb-3"> 
                                        <input type="text" class="form-control" id="phone" name="mobile" placeholder="Mobile Number" required>
                                    </div>
                                    <div class="mb-3"> 
                                        <input type="email" class="form-control" id="userEmail" name="email" placeholder="Email">
                                    </div>
                                    <div class="mb-3">
                                        <select class="form-select" name="enquiry" aria-label="Default select example">
                                            <option selected="">Select Options</option>
                                            <option value="Service Enquiry">Service Enquiry</option>
                                            <option value="Product Enquiry">Product Enquiry</option>
                                            <option value="Price Enquiry">Price Enquiry</option>
                                            <option value="Be a Dealer">Be a Dealer</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <select class="form-select txtstate" name="state">
                                            <option value="">Select State *</option>
                                            <option value="Andaman &amp;Nicobar Island">Andaman &amp;Nicobar Island</option>
                                            <option value="Andhra Pradesh">Andhra Pradesh</option>
                                            <option value="Arunachal Pradesh">Arunachal Pradesh</option>
                                            <option value="Assam">Assam</option>
                                            <option value="Bihar">Bihar</option>
                                            <option value="Chandigarh">Chandigarh</option>
                                            <option value="Chhattisgarh">Chhattisgarh</option>
                                            <option value="Dadra &amp; Nagar Haveli">Dadra &amp; Nagar Haveli</option>
                                            <option value="Daman &amp; Diu">Daman &amp; Diu</option>
                                            <option value="Delhi">Delhi</option>
                                            <option value="Goa">Goa</option>
                                            <option value="Gujarat">Gujarat</option>
                                            <option value="Haryana">Haryana</option>
                                            <option value="Himachal Pradesh">Himachal Pradesh</option>
                                            <option value="Jammu &amp; Kashmir">Jammu &amp; Kashmir</option>
                                            <option value="Jharkhand">Jharkhand</option>
                                            <option value="Karnataka">Karnataka</option>
                                            <option value="Kerala">Kerala</option>
                                            <option value="Lakshadweep">Lakshadweep</option>
                                            <option value="Madhya Pradesh">Madhya Pradesh</option>
                                            <option value="Maharashtra">Maharashtra</option>
                                            <option value="Manipur">Manipur</option>
                                            <option value="Meghalaya">Meghalaya</option>
                                            <option value="Mizoram">Mizoram</option>
                                            <option value="Nagaland">Nagaland</option>
                                            <option value="Orissa">Orissa</option>
                                            <option value="Pondicherry">Pondicherry</option>
                                            <option value="Punjab">Punjab</option>
                                            <option value="Rajasthan">Rajasthan</option>
                                            <option value="Sikkim">Sikkim</option>
                                            <option value="Tamilnadu">Tamilnadu</option>
                                            <option value="Tripura">Tripura</option>
                                            <option value="Uttar Pradesh">Uttar Pradesh</option>
                                            <option value="Uttaranchal">Uttaranchal</option>
                                            <option value="West Bengal">West Bengal</option>
                                        </select>
                                    </div>
                                    <div class="mb-3"> 
                                        <input type="text" class="form-control" id="userCity" name="city" placeholder="Enter City">
                                    </div>
                                    <div class="mb-3"> 
                                            <input type="text" class="form-control" id="postTitle" name="posttitle" placeholder="Post Title" readonly>
                                           
                                        </div>
                                    <div class="mb-3">
                                        <div class="form-floating">
                                            <textarea class="form-control" placeholder="Leave a comment here" name="message" id="floatingTextarea2" style="height: 100px"></textarea>
                                            <label for="floatingTextarea2">Comments</label>
                                        </div>
                                    </div>
                                    
                                        
								   <input type="hidden" id="model_name" class="form-control"  aria-describedby="textHelp" value="">
                                    <!--<button type="submit" class="btn btn-primary">Submit</button>-->
                                    <input type="hidden" value="send_data" name="action">
                            <input type="button" id="submitform"  name="submitvalue" value="Submit" onclick="sendvalue()" class="btn btn-primary">
                                </form>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </section>
    <script src="<?php echo get_site_url();?>/wp-content/themes/vst/js/jquery.min.js?ver=3.6.0"></script>
    <script>
		function sendvalue() {
                      $("#submitform").val("Submitting...");
		        $.ajax({
              method: "POST",
              url : "<?php echo admin_url('admin-ajax.php'); ?>",
              data: $("#senddata").serialize()
              //data: { action: "send_data", page_num: "hi" }
              
            }).done(function(response) {
                console.log(response);
                $("body").append(response);
				$("#submitform").val("Submitted");
              });
		    }  
		</script>
		
    <!-- Why VST Series 9 end -->

   
    

<script>
    function populatePostTitle(productTitle) {
        const postTitleInput = document.getElementById("postTitle");
        if (postTitleInput) {
            postTitleInput.value = productTitle;
        }
    }

    document.addEventListener("DOMContentLoaded", function() {
        const specificationLinks = document.querySelectorAll('[data-bs-toggle="modal"][data-bs-target="#full-specification"]');
        specificationLinks.forEach(link => {
            link.addEventListener("click", function(event) {
                event.preventDefault();
                const productTitle = this.getAttribute("data-product-title");
                populatePostTitle(productTitle);
            });
        });
    });
</script>

<script>
    // document.addEventListener("DOMContentLoaded", function() {
    //     // Get a reference to the modal title element
    //     var modalTitle = document.querySelector("#model_name");

    //     // Get all "Full Specifications" buttons
    //     var fullSpecButtons = document.querySelectorAll("[data-bs-toggle='modal'][data-bs-target='#full-specification']");

    //     // Attach a click event listener to each button
    //     fullSpecButtons.forEach(function(button) {
    //         button.addEventListener("click", function(event) {
    //             // Get the product title from the custom attribute
    //             var productTitle = this.getAttribute("data-product-title");
                
    //             // Update the modal title with the product title
    //             modalTitle.textContent = productTitle;
    //         });
    //     });
    // });
</script>

<?php get_footer();?>