<?php
// Register Custom Post Type
function product_post_type() {

	$labels = array(
		'name'                  => _x( 'Our Products', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Our Product', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Our Products', 'text_domain' ),
		'name_admin_bar'        => __( 'Our Products', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Item:', 'text_domain' ),
		'all_items'             => __( 'All Products', 'text_domain' ),
		'add_new_item'          => __( 'Add New Product', 'text_domain' ),
		'add_new'               => __( 'Add New', 'text_domain' ),
		'new_item'              => __( 'New Product', 'text_domain' ),
		'edit_item'             => __( 'Edit Product', 'text_domain' ),
		'update_item'           => __( 'Update Product', 'text_domain' ),
		'view_item'             => __( 'View Product', 'text_domain' ),
		'view_items'            => __( 'View Products', 'text_domain' ),
		'search_items'          => __( 'Search Product', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into Product', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Product', 'text_domain' ),
		'items_list'            => __( 'Products list', 'text_domain' ),
		'items_list_navigation' => __( 'Products list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter Products list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Our Product', 'text_domain' ),
		'description'           => __( 'Product Type Description', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
// 		'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'product', $args );

}
add_action( 'init', 'product_post_type', 0 );

function custom_product_type_taxonomy() {
	$labels = array(
		'name' => _x( 'Products Category', 'Taxonomy General Name', 'text_domain' ),
		'singular_name' => _x( 'Products Category', 'Taxonomy Singular Name', 'text_domain' ),
		'menu_name' => __( 'Products Category', 'text_domain' ),
		'all_items' => __( 'All Items', 'text_domain' ),
		'parent_item' => __( 'Parent Item', 'text_domain' ),
		'parent_item_colon' => __( 'Parent Item:', 'text_domain' ),
		'new_item_name' => __( 'New Item Name', 'text_domain' ),
		'add_new_item' => __( 'Add New Item', 'text_domain' ),
		'edit_item' => __( 'Edit Item', 'text_domain' ),
		'update_item' => __( 'Update Item', 'text_domain' ),
		'view_item' => __( 'View Item', 'text_domain' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'text_domain' ),
		'add_or_remove_items' => __( 'Add or remove items', 'text_domain' ),
		'choose_from_most_used' => __( 'Choose from the most used', 'text_domain' ),
		'popular_items' => __( 'Popular Items', 'text_domain' ),
		'search_items' => __( 'Search Items', 'text_domain' ),
		'not_found' => __( 'Not Found', 'text_domain' ),
		'no_terms' => __( 'No items', 'text_domain' ),
		'items_list' => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => true,
		'public' => true,
        'rewrite' => array( 'slug' => 'product-category','with_front'=> false ),
		'show_ui' => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => false,
		'show_tagcloud' => false,
		'depth' => 2,
	);
	register_taxonomy( 'product-category', array( 'product' ), $args );
}
add_action( 'init', 'custom_product_type_taxonomy', 0 );

// Register Job Custom Post Type
function job_post_type() {

	$labels = array(
		'name'                  => _x( 'Jobs', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Job', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Jobs', 'text_domain' ),
		'name_admin_bar'        => __( 'Jobs', 'text_domain' ),
		'archives'              => __(  'Job Archives', 'text_domain' ),
		'attributes'            => __(  'Job Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Job:', 'text_domain' ),
		'all_items'             => __( 'All Jobs', 'text_domain' ),
		'add_new_item'          => __( 'Add New Job', 'text_domain' ),
		'add_new'               => __( 'Add New', 'text_domain' ),
		'new_item'              => __( 'New Job', 'text_domain' ),
		'edit_item'             => __( 'Edit Job', 'text_domain' ),
		'update_item'           => __( 'Update Job', 'text_domain' ),
		'view_item'             => __( 'View Job', 'text_domain' ),
		'view_items'            => __( 'View Jobs', 'text_domain' ),
		'search_items'          => __( 'Search Job', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __(  'Jobs list', 'text_domain' ),
		'items_list_navigation' => __(  'Jobs list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter Jobs list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Job', 'text_domain' ),
		'description'           => __( 'Job Type Description', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments','excerpt', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
// 		'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'job', $args );

}
add_action( 'init', 'job_post_type', 0 );

// Register Job Categories Custom Taxonomy start
function custom_job_type_taxonomy() {
	$labels = array(
		'name' => _x( 'Jobs Category', 'Taxonomy General Name', 'text_domain' ),
		'singular_name' => _x( 'Jobs Category', 'Taxonomy Singular Name', 'text_domain' ),
		'menu_name' => __( 'Jobs Category', 'text_domain' ),
		'all_items' => __( 'All Items', 'text_domain' ),
		'parent_item' => __( 'Parent Item', 'text_domain' ),
		'parent_item_colon' => __( 'Parent Item:', 'text_domain' ),
		'new_item_name' => __( 'New Item Name', 'text_domain' ),
		'add_new_item' => __( 'Add New Item', 'text_domain' ),
		'edit_item' => __( 'Edit Item', 'text_domain' ),
		'update_item' => __( 'Update Item', 'text_domain' ),
		'view_item' => __( 'View Item', 'text_domain' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'text_domain' ),
		'add_or_remove_items' => __( 'Add or remove items', 'text_domain' ),
		'choose_from_most_used' => __( 'Choose from the most used', 'text_domain' ),
		'popular_items' => __( 'Popular Items', 'text_domain' ),
		'search_items' => __( 'Search Items', 'text_domain' ),
		'not_found' => __( 'Not Found', 'text_domain' ),
		'no_terms' => __( 'No items', 'text_domain' ),
		'items_list' => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => true,
		'public' => true,
        'rewrite' => array( 'slug' => 'jobs-category','with_front'=> false ),
		'show_ui' => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => false,
		'show_tagcloud' => false,
	);
	register_taxonomy( 'jobs-category', array( 'job' ), $args );
}
add_action( 'init', 'custom_job_type_taxonomy', 0 );

// Register Job Location Custom Taxonomy start
function custom_job_location_taxonomy() {
    $labels = array(
        'name' => _x( 'Jobs Location', 'Taxonomy General Name', 'text_domain' ),
        'singular_name' => _x( 'Jobs Location', 'Taxonomy Singular Name', 'text_domain' ),
        'menu_name' => __( 'Jobs Location', 'text_domain' ),
        'all_items' => __( 'All Items', 'text_domain' ),
        'parent_item' => __( 'Parent Item', 'text_domain' ),
        'parent_item_colon' => __( 'Parent Item:', 'text_domain' ),
        'new_item_name' => __( 'New Item Name', 'text_domain' ),
        'add_new_item' => __( 'Add New Item', 'text_domain' ),
        'edit_item' => __( 'Edit Item', 'text_domain' ),
        'update_item' => __( 'Update Item', 'text_domain' ),
        'view_item' => __( 'View Item', 'text_domain' ),
        'separate_items_with_commas' => __( 'Separate items with commas', 'text_domain' ),
        'add_or_remove_items' => __( 'Add or remove items', 'text_domain' ),
        'choose_from_most_used' => __( 'Choose from the most used', 'text_domain' ),
        'popular_items' => __( 'Popular Items', 'text_domain' ),
        'search_items' => __( 'Search Items', 'text_domain' ),
        'not_found' => __( 'Not Found', 'text_domain' ),
        'no_terms' => __( 'No items', 'text_domain' ),
        'items_list' => __( 'Items list', 'text_domain' ),
        'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
    );
    $args = array(
        'labels' => $labels,
        'hierarchical' => true,
        'public' => true,
        'rewrite' => array( 'slug' => 'jobs-location','with_front'=> false ),
        'show_ui' => true,
        'show_admin_column' => true,
        'show_in_nav_menus' => false,
        'show_tagcloud' => false,
    );
    register_taxonomy( 'jobs-location', array( 'job' ), $args );
}
add_action( 'init', 'custom_job_location_taxonomy', 0 );

// Register Dealer Custom Post Type
function dealer_locator_type() {

	$labels = array(
		'name'                  => _x( 'Dealer Locator', 'Post Type General Name', 'text_domain' ),
		'singular_name'         => _x( 'Dealer Locator', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'             => __( 'Dealer Locator', 'text_domain' ),
		'name_admin_bar'        => __( 'Dealer Locator', 'text_domain' ),
		'archives'              => __( 'Item Archives', 'text_domain' ),
		'attributes'            => __( 'Item Attributes', 'text_domain' ),
		'parent_item_colon'     => __( 'Parent Item:', 'text_domain' ),
		'all_items'             => __( 'All Items', 'text_domain' ),
		'add_new_item'          => __( 'Add New Item', 'text_domain' ),
		'add_new'               => __( 'Add New', 'text_domain' ),
		'new_item'              => __( 'New Item', 'text_domain' ),
		'edit_item'             => __( 'Edit Item', 'text_domain' ),
		'update_item'           => __( 'Update Item', 'text_domain' ),
		'view_item'             => __( 'View Item', 'text_domain' ),
		'view_items'            => __( 'View Items', 'text_domain' ),
		'search_items'          => __( 'Search Item', 'text_domain' ),
		'not_found'             => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
		'featured_image'        => __( 'Featured Image', 'text_domain' ),
		'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
		'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
		'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
		'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
		'items_list'            => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
		'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
	);
	$args = array(
		'label'                 => __( 'Dealer Locator', 'text_domain' ),
		'description'           => __( 'Post Type Description', 'text_domain' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'comments', 'trackbacks', 'excerpt', 'revisions', 'custom-fields', 'page-attributes', 'post-formats' ),
// 		'taxonomies'            => array( 'category', 'post_tag' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'dealer-locator', $args );

}
add_action( 'init', 'dealer_locator_type', 0 );

function custom_dealer_type_taxonomy() {
	$labels = array(
		'name' => _x( 'Dealers Category', 'Taxonomy General Name', 'text_domain' ),
		'singular_name' => _x( 'Dealers Category', 'Taxonomy Singular Name', 'text_domain' ),
		'menu_name' => __( 'Dealers Category', 'text_domain' ),
		'all_items' => __( 'All Items', 'text_domain' ),
		'parent_item' => __( 'Parent Item', 'text_domain' ),
		'parent_item_colon' => __( 'Parent Item:', 'text_domain' ),
		'new_item_name' => __( 'New Item Name', 'text_domain' ),
		'add_new_item' => __( 'Add New Item', 'text_domain' ),
		'edit_item' => __( 'Edit Item', 'text_domain' ),
		'update_item' => __( 'Update Item', 'text_domain' ),
		'view_item' => __( 'View Item', 'text_domain' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'text_domain' ),
		'add_or_remove_items' => __( 'Add or remove items', 'text_domain' ),
		'choose_from_most_used' => __( 'Choose from the most used', 'text_domain' ),
		'popular_items' => __( 'Popular Items', 'text_domain' ),
		'search_items' => __( 'Search Items', 'text_domain' ),
		'not_found' => __( 'Not Found', 'text_domain' ),
		'no_terms' => __( 'No items', 'text_domain' ),
		'items_list' => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => true,
		'public' => true,
        'rewrite' => array( 'slug' => 'dealer-category','with_front'=> false ),
		'show_ui' => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => false,
		'show_tagcloud' => false,
		'depth' => 2,
	);
	register_taxonomy( 'dealer-category', array( 'dealer-locator' ), $args );
}
add_action( 'init', 'custom_dealer_type_taxonomy', 0 );


// Dealer state category

function custom_state_dealer_taxonomy() {
	$labels = array(
		'name' => _x( 'Dealers State', 'Taxonomy General Name', 'text_domain' ),
		'singular_name' => _x( 'Dealers State Category', 'Taxonomy Singular Name', 'text_domain' ),
		'menu_name' => __( 'Dealers State Category', 'text_domain' ),
		'all_items' => __( 'All Items', 'text_domain' ),
		'parent_item' => __( 'Parent Item', 'text_domain' ),
		'parent_item_colon' => __( 'Parent Item:', 'text_domain' ),
		'new_item_name' => __( 'New Item Name', 'text_domain' ),
		'add_new_item' => __( 'Add New Item', 'text_domain' ),
		'edit_item' => __( 'Edit Item', 'text_domain' ),
		'update_item' => __( 'Update Item', 'text_domain' ),
		'view_item' => __( 'View Item', 'text_domain' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'text_domain' ),
		'add_or_remove_items' => __( 'Add or remove items', 'text_domain' ),
		'choose_from_most_used' => __( 'Choose from the most used', 'text_domain' ),
		'popular_items' => __( 'Popular Items', 'text_domain' ),
		'search_items' => __( 'Search Items', 'text_domain' ),
		'not_found' => __( 'Not Found', 'text_domain' ),
		'no_terms' => __( 'No items', 'text_domain' ),
		'items_list' => __( 'Items list', 'text_domain' ),
		'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => true,
		'public' => true,
        'rewrite' => array( 'slug' => 'dealer-state','with_front'=> false ),
		'show_ui' => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => false,
		'show_tagcloud' => false,
		'depth' => 2,
	);
	register_taxonomy( 'dealer-state', array( 'dealer-locator' ), $args );
}
add_action( 'init', 'custom_state_dealer_taxonomy', 0 );
?>