<?php 

/* Add Required Supports for Custom wordpress theme */
add_theme_support( 'automatic-feed-links' );

// title tag
add_theme_support( 'title-tag' );
// Logo
add_theme_support( 'custom-logo' );

//add_theme_support('category-thumbnails');

// post thumbnail
add_theme_support( 'post-thumbnails' );
// since 2.4
add_theme_support( 'woocommerce' );
// html5
add_theme_support( 'html5', array(
'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
) );

// menu
function wpb_custom_new_menu() {
  register_nav_menus(
    array(
      'footer-first-menu' => __( 'Footer First Menu' ), 
      'footer-second-menu' => __( 'Footer Second Menu' ),
      'header-first-menu' => __( 'Header First Menu' )
    )
  );
}
add_action( 'init', 'wpb_custom_new_menu' );

// sidebar 
function wpb_widgets_init() {
    register_sidebar( array(
        'name' =>__( 'Footer First sidebar', 'wpb'),
        'id' => 'sidebar-1',
        'description' => __( 'Appears on the static front page template', 'wpb' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ) );
    register_sidebar( array(
        'name' =>__( 'Footer Second sidebar', 'wpb'),
        'id' => 'sidebar-2',
        'description' => __( 'Appears on the static front page template', 'wpb' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ) );
    register_sidebar( array(
        'name' =>__( 'Footer Third sidebar', 'wpb'),
        'id' => 'sidebar-3',
        'description' => __( 'Appears on the static front page template', 'wpb' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ) );
    register_sidebar( array(
        'name' =>__( 'Footer Fourth sidebar', 'wpb'),
        'id' => 'sidebar-4',
        'description' => __( 'Appears on the static front page template', 'wpb' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ) );
    } 
add_action( 'widgets_init', 'wpb_widgets_init' );


//add SVG to allowed file uploads
function add_for_svg_file_types_to_uploads($file_types){

     $new_filetypes = array();
     $new_filetypes['svg'] = 'image/svg';
     $file_types = array_merge($file_types, $new_filetypes );

     return $file_types; 
} 
add_action('upload_mimes', 'add_for_svg_file_types_to_uploads');