<?php

/* Add requried support in Theme */
include_once('inc/add_theme_supports.php');

/* Include Css & JS files */
include_once('inc/include_scripts.php');

/* Include Customizer For Footer Social Links */
include_once('inc/customizer-social-section.php');

/* Include Custom Post Type */
include_once('inc/custom-post-types.php');

/* Include Menu */
include_once('inc/class-wp-bootstrap-navwalker.php');

/* Include Custom Form Data */
include_once('inc/custom-form-data.php');

// Silence is Golden

// title get 
add_filter('gform_pre_render_3', 'populate_job_posts');
// add_filter('gform_pre_validation_3', 'populate_job_posts');
// add_filter('gform_pre_submission_filter_3', 'populate_job_posts');
// add_filter('gform_admin_pre_render_3', 'populate_job_posts');

function populate_job_posts($form) {
    foreach ($form['fields'] as &$field) {
        // if ($field->type != 'select' || strpos($field->cssClass, 'populate-posts') === false) {
        //     continue;
        // }

if($field->cssClass == 'dynamic_jobs'){

        // Customize the parameters for the get_posts() function to suit your needs.
        $job_posts = get_posts(array(
            'post_type' => 'job',
            'numberposts' => -1,
            'post_status' => 'publish',
        ));

        $choices = array();

        foreach ($job_posts as $job_post) {
            $choices[] = array('text' => $job_post->post_title, 'value' => $job_post->ID);
        }

        // Update the placeholder text for the dropdown field.
        $field->placeholder = 'Applied For*';
        $field->choices = $choices;
    }
    }

    return $form;
}

// get-user-ip-location-for-top-banner-section-start-here

function get_user_location() {
    $ip_address = $_SERVER['HTTP_X_FORWARDED_FOR'];
    $api_url = "https://ipinfo.io/{$ip_address}/json";
//   $api_url = file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $ip);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);

    if (isset($data['region'])) {
        return $data['region'];
    }

    return '';
}
// get-user-ip-location-for-top-banner-section-end-here

function include_custom_post_types_in_search_results( $query ) {
    if ( $query->is_main_query() && $query->is_search() && ! is_admin() ) {
        $query->set( 'post_type', array( 'post', 'product', 'job', 'dealer-locator' ) );
    }
}
add_action( 'pre_get_posts', 'include_custom_post_types_in_search_results' );







function add_import_page() {
    add_submenu_page(
        'edit.php?post_type=dealer-locator',
        'Import Dealer Locator', 
        'Import', 
        'manage_options', 
        'import-cpt', 
        'import_page_callback'
    );
}
add_action('admin_menu', 'add_import_page');

function import_page_callback() {
    ?>
    <div class="wrap">
        <h2>Import Dealer Locator from CSV</h2>
        <form method="post" enctype="multipart/form-data">
            <input type="file" name="import_file" />
            <input type="submit" name="import_submit" value="Import CSV" class="button-primary" />
        </form>
    </div>
    <?php

    if (isset($_POST['import_submit'])) {
        handle_csv_import();
    }
}

function handle_csv_import() {
    if ( ! isset( $_FILES['import_file']['tmp_name'] ) || empty( $_FILES['import_file']['tmp_name'] ) ) {
        echo '<div class="error"><p>Please upload a valid CSV file.</p></div>';
        return;
    }

    // Open the uploaded CSV file
    $csv_file = fopen( $_FILES['import_file']['tmp_name'], 'r' );
    if ( $csv_file === false ) {
        echo '<div class="error"><p>Unable to open the CSV file.</p></div>';
        return;
    }

    // Skip the header row
    fgetcsv($csv_file);

    // Loop through the rows
    while (($row = fgetcsv($csv_file, 1000, ',')) !== false) {
        $dealers_state_category = sanitize_text_field($row[1]); 
        $district = sanitize_text_field($row[2]);
        $post_title = sanitize_text_field($row[3]);
        $dealer_name = sanitize_text_field($row[4]);
        $dealer_address = sanitize_text_field($row[5]);
        $dealer_phone = sanitize_text_field($row[7]);
        $dealer_email = sanitize_text_field($row[8]);    
        $dealer_location_map = sanitize_text_field($row[9]);
        $dealer_whatsapp_number = sanitize_text_field($row[10]);
        $dealer_cta = sanitize_text_field($row[11]);
  
      
        
        $dealer_category_name = 'SFM'; // Category name

        // Check if the dealer category exists
        $dealer_category_term = term_exists($dealer_category_name, 'dealer-category');

        // If it doesn't exist, create it
        if (!$dealer_category_term) {
            $dealer_category_term = wp_insert_term($dealer_category_name, 'dealer-category');
        }

        $dealer_category_id = is_array($dealer_category_term) ? $dealer_category_term['term_id'] : $dealer_category_term; 




        // Check if the dealer category exists
        $dealer_state_category_term = term_exists($dealers_state_category, 'dealer-state');

        // If it doesn't exist, create it
        if (!$dealer_state_category_term) {
            $dealer_state_category_term = wp_insert_term($dealers_state_category, 'dealer-state');
        }

        $dealer_state_category_id = is_array($dealer_state_category_term) ? $dealer_state_category_term['term_id'] : $dealer_state_category_term; 




        
        
    
            // Create a new post
            $post_id = wp_insert_post(array(
                 'post_title'   => $post_title,
                'post_status'  => 'publish',
                'post_type'    => 'dealer-locator'
            ));
        

        // Update the ACF fields
        if ($post_id) {
            update_field('dealer_name', $dealer_name, $post_id); 
            update_field('dealer_email', $dealer_email, $post_id); 
            update_field('dealer_phone', $dealer_phone, $post_id); 
            update_field('district', $district, $post_id); 
            update_field('dealer_address', $dealer_address, $post_id); 
            update_field('dealer_location_map', $dealer_location_map, $post_id); 
            update_field('dealer_cta', $dealer_cta, $post_id); 
            update_field('dealer_whatsapp_number', $dealer_whatsapp_number, $post_id); 
        }
         // Assign the taxonomy term
         if ($dealer_state_category_id) {
            wp_set_post_terms( $post_id, array( $dealer_state_category_id ), 'dealer-state', false );
        }
        if($dealer_category_id)
        {
            wp_set_post_terms( $post_id, array( $dealer_category_id ), 'dealer-category', false );
        }
      
    }

    // Close the CSV file
    fclose($csv_file);

    echo '<div class="updated"><p>Import completed successfully!</p></div>';
}